#include <stdio.h>
#include <stdlib.h>

typedef struct
{
    int x, y;
} Tacka;
double povrsina(Tacka *h, int n) 
{
    double p = 0;
    for (int i = 0; i < n; i++) 
    {
        int j = (i + 1) % n;
        p += h[i].x * h[j].y;
        p -= h[i].y * h[j].x;
    }
    return abs(p) / 2.0;
}
int uporedi(const void *a, const void *b) 
{
    Tacka *p1 = (Tacka*)a;
    Tacka *p2 = (Tacka*)b;
    if (p1->x == p2->x) return p1->y - p2->y;
    return p1->x - p2->x;
}
int orjentacija(Tacka p, Tacka q, Tacka r) 
{
    return (q.x - p.x) * (r.y - p.y) - (q.y - p.y) * (r.x - p.x);
}
int mnogougao(Tacka *p, int n, Tacka *h) 
{
    qsort(p, n, sizeof(Tacka), uporedi);
    int k = 0;
    for (int i = 0; i < n; i++) 
    {
        while (k >= 2 && orjentacija(h[k-2], h[k-1], p[i]) <= 0) 
        {
            k--;
        }
        h[k++] = p[i];
    }
    int t = k + 1;
    for (int i = n - 2; i >= 0; i--) 
    {
        while (k >= t && orjentacija(h[k-2], h[k-1], p[i]) <= 0) 
        {
            k--;
        }
        h[k++] = p[i];
    }

    return k - 1;
}
int main() 
{
    int n;
    scanf("%d", &n);
    Tacka p[n];
    for (int i = 0; i < n; i++) 
    {
        scanf("%d", &p[i].x);
        scanf("%d", &p[i].y);
    }
    Tacka h1[n];
    int h2 = mnogougao(p, n, h1);
    double min = povrsina(h1, h2);
    for (int i = 0; i < n; i++) 
    {
        Tacka p1[n-1];
        int id = 0;
        for (int j = 0; j < n; j++) 
        {
            if (j != i) 
            {
                p1[id++] = p[j];
            }
        }
        Tacka h3[n];
        int h4 = mnogougao(p1, n-1, h3);
        double pom = povrsina(h3, h4);
        if (pom < min) 
        {
            min = pom;
        }
    }
    printf("%d\n", (int)min);
    return 0;
}